/****** Object:  UserDefinedFunction [dbo].[UFD_RELA_PED_CP_LIB]    Script Date: 05/23/2013 23:38:15 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UFD_RELA_PED_CP_LIB]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[UFD_RELA_PED_CP_LIB]
GO
GO
GO
GO

CREATE  FUNCTION [dbo].[UFD_RELA_PED_CP_LIB] (	@CD_EMP		INT,
							@CD_FILIAL_ORIG	INT,
							@CD_FILIAL_SELE	VARCHAR(2000),
							@CD_LIN		VARCHAR(2000),
							@GRP_FILIAL		INT
						)

-- @GRP_FILIAL : 	SE 1 ENTO AGRUPAR POR FILIAL, 
--			SENO DESCONSIDERAR FILIAL E AGRUPAR POR CD_PROD

RETURNS @RS_DADOS TABLE (CD_FILIAL	INT,
				CD_PROD			INT,
				DS_PROD			VARCHAR(250),
				STS_PROD		INT,
				DS_UN			VARCHAR(10),
				VLR_CUSTO		MONEY,
				QT_IT_UN		MONEY,
				QT_IT_SOLI		MONEY,
				APRES_QT_CP		MONEY,
				APRES_EMB_CP	VARCHAR(10),
				QT_IT_CP		MONEY,
				VLR_IT_CP		MONEY,
				CD_SC			INT,
				CURVA_FILIAL	VARCHAR(10), 
				CURVA_MTZ		VARCHAR(10),
				QT_PEND_ENT		MONEY,
				EMAX			MONEY,
				ESEG			MONEY,
				MEDIAF			MONEY,	
				QT_EST			MONEY,
				CD_FABRIC       INT,
				COMPRA_POR_SUPRIMENTO		INT,
				QT_EST_MTZ		MONEY)

AS
BEGIN


DECLARE @RS_MTZ TABLE  (	CD_PROD 	INT,
					CURVA_MTZ	VARCHAR(10),
					QT_EST_MTZ MONEY
				)
				

IF @GRP_FILIAL = 1
	INSERT INTO @RS_DADOS
		SELECT 
			EST_PROD_REQ_TRANSF_SLD.CD_FILIAL,
			EST_PROD_REQ_TRANSF_SLD.CD_PROD,  
			EST_PROD.DS_PROD, 
			EST_PROD_CPL.STS_PROD,
			EST_PROD_UN_MED.DS_UN, 
			EST_PROD_CPL.VLR_CUSTO_MD AS VLR_CUSTO,  
			SUM(EST_PROD_REQ_TRANSF_SLD.QT_PROD) AS QT_IT_UN,  
			SUM(ROUND(EST_PROD_REQ_TRANSF_SLD.QT_PROD / EST_PROD.APRES_QT_CP, 0)) AS QT_IT_SOLI,  
			EST_PROD.APRES_QT_CP, 
			EST_PROD.APRES_EMB_CP,  
			SUM(ROUND(EST_PROD_REQ_TRANSF_SLD.QT_PROD / EST_PROD.APRES_QT_CP, 0)) AS QT_IT_CP, 
			EST_PROD.VLR_COMPRA_GRP AS VLR_IT_CP, 
			EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA ,
			EST_PROD_CURVA_SIGLA.DS_SIGLA AS CURVA_FILIAL,
			'' AS CURVA_MTZ,
			V_EST_PROD_CPL_PENDENCIAS.QT_PEND_ENT,
			EST_PROD_CPL.EMAX,
			EST_PROD_CPL.ESEG,
			EST_PROD_CPL.MEDIAF,
			EST_PROD_CPL.QT_EST,
			EST_PROD.CD_FABRIC,
			EST_PROD.COMPRA_POR_SUPRIMENTO,
			0 AS QT_EST_MTZ
		FROM 
			EST_PROD INNER JOIN EST_PROD_CPL ON
			EST_PROD.CD_EMP = EST_PROD_CPL.CD_EMP AND  
			EST_PROD.CD_PROD = EST_PROD_CPL.CD_PROD 
			INNER JOIN EST_PROD_REQ_TRANSF_SLD ON
			EST_PROD_CPL.CD_EMP = EST_PROD_REQ_TRANSF_SLD.CD_EMP AND 
			EST_PROD_CPL.CD_FILIAL = EST_PROD_REQ_TRANSF_SLD.CD_FILIAL AND 
			EST_PROD_CPL.CD_PROD = EST_PROD_REQ_TRANSF_SLD.CD_PROD 
			INNER JOIN EST_PROD_UN_MED ON
			EST_PROD.CD_EMP = EST_PROD_UN_MED.CD_EMP AND  
			EST_PROD.CD_UN_CP = EST_PROD_UN_MED.CD_CTR_UN 
			INNER JOIN EST_PROD_CURVA_SIGLA ON 
			EST_PROD_CURVA_SIGLA.CD_EMP = EST_PROD_CPL.CD_EMP AND 
			EST_PROD_CURVA_SIGLA.CD_SIGLA = EST_PROD_CPL.CD_SIGLA 
            INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA  ON
			EST_PROD.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP AND
			EST_PROD.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD
			INNER JOIN V_EST_PROD_CPL_PENDENCIAS ON	
			EST_PROD_CPL.CD_EMP = V_EST_PROD_CPL_PENDENCIAS.CD_EMP AND
			EST_PROD_CPL.CD_FILIAL = V_EST_PROD_CPL_PENDENCIAS.CD_FILIAL AND
			EST_PROD_CPL.CD_PROD = V_EST_PROD_CPL_PENDENCIAS.CD_PROD
		WHERE 
			EST_PROD_REQ_TRANSF_SLD.CD_EMP = @CD_EMP AND 
			EST_PROD_REQ_TRANSF_SLD.CD_FILIAL_ORIG_PROD = @CD_FILIAL_ORIG AND 
			EST_PROD_REQ_TRANSF_SLD.QT_PROD > 0  AND 
			EST_PROD_CPL.TP_PROD = 0  AND 
			EST_PROD_REQ_TRANSF_SLD.CD_FILIAL IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_FILIAL_SELE)) AND 
			EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA IN(SELECT ID FROM UFD_PRM_IN_STRING(@CD_LIN)) 
		GROUP BY 
			EST_PROD_REQ_TRANSF_SLD.CD_FILIAL,
			EST_PROD_REQ_TRANSF_SLD.CD_PROD,  
			EST_PROD.DS_PROD, 
			EST_PROD_CPL.STS_PROD,
			EST_PROD_UN_MED.DS_UN, 
			EST_PROD.VLR_CUSTO_GRP,  
			EST_PROD.APRES_QT_CP, 
			EST_PROD.APRES_EMB_CP,  
			EST_PROD.VLR_COMPRA_GRP, 
			EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA ,
			EST_PROD_CURVA_SIGLA.DS_SIGLA,
			V_EST_PROD_CPL_PENDENCIAS.QT_PEND_ENT,
			EST_PROD_CPL.EMAX,
			EST_PROD_CPL.ESEG,
			EST_PROD_CPL.MEDIAF,
			EST_PROD_CPL.QT_EST,
			EST_PROD.CD_FABRIC,
			EST_PROD.COMPRA_POR_SUPRIMENTO,
			EST_PROD_CPL.VLR_CUSTO_MD

ELSE
	INSERT INTO @RS_DADOS
		SELECT 
			0,
			EST_PROD_REQ_TRANSF_SLD.CD_PROD,  
			EST_PROD.DS_PROD, 
			EST_PROD_CPL.STS_PROD,
			EST_PROD_UN_MED.DS_UN, 
			EST_PROD_CPL.VLR_CUSTO_MD AS VLR_CUSTO, 
			SUM(EST_PROD_REQ_TRANSF_SLD.QT_PROD) AS QT_IT_UN,  
			SUM(ROUND(EST_PROD_REQ_TRANSF_SLD.QT_PROD / EST_PROD.APRES_QT_CP, 0)) AS QT_IT_SOLI,  
			EST_PROD.APRES_QT_CP, 
			EST_PROD.APRES_EMB_CP,  
			SUM(ROUND(EST_PROD_REQ_TRANSF_SLD.QT_PROD / EST_PROD.APRES_QT_CP, 0)) AS QT_IT_CP, 
			EST_PROD.VLR_COMPRA_GRP AS VLR_IT_CP, 
			EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA ,
			'' AS CURVA_FILIAL,
			'' AS CURVA_MTZ,
			0 AS QT_PEND_ENT,
			0 AS EMAX,
			0 AS ESEG,
			0 AS MEDIAF,
			0 AS QT_EST,
			EST_PROD.CD_FABRIC,
			EST_PROD.COMPRA_POR_SUPRIMENTO,
			0 AS QT_EST_MTZ		
		FROM 
			EST_PROD INNER JOIN EST_PROD_CPL ON 
			EST_PROD.CD_EMP = EST_PROD_CPL.CD_EMP AND
			EST_PROD.CD_PROD = EST_PROD_CPL.CD_PROD 
			INNER JOIN EST_PROD_REQ_TRANSF_SLD ON
			EST_PROD_CPL.CD_EMP = EST_PROD_REQ_TRANSF_SLD.CD_EMP AND 
			EST_PROD_CPL.CD_FILIAL = EST_PROD_REQ_TRANSF_SLD.CD_FILIAL AND 
			EST_PROD_CPL.CD_PROD = EST_PROD_REQ_TRANSF_SLD.CD_PROD 
			INNER JOIN EST_PROD_UN_MED ON 
			EST_PROD.CD_EMP = EST_PROD_UN_MED.CD_EMP AND  
			EST_PROD.CD_UN_CP = EST_PROD_UN_MED.CD_CTR_UN 
			INNER JOIN EST_PROD_CURVA_SIGLA ON  
			EST_PROD_CURVA_SIGLA.CD_EMP = EST_PROD_CPL.CD_EMP AND 
			EST_PROD_CURVA_SIGLA.CD_SIGLA = EST_PROD_CPL.CD_SIGLA 
			INNER JOIN EST_PROD_EST_ARV_MERCADOLOGICA  ON
            EST_PROD.CD_EMP = EST_PROD_EST_ARV_MERCADOLOGICA.CD_EMP AND
			EST_PROD.CD_PROD = EST_PROD_EST_ARV_MERCADOLOGICA.CD_PROD 
		WHERE 
			EST_PROD_REQ_TRANSF_SLD.CD_EMP = @CD_EMP AND 
			EST_PROD_REQ_TRANSF_SLD.CD_FILIAL_ORIG_PROD = @CD_FILIAL_ORIG AND 
			EST_PROD_REQ_TRANSF_SLD.QT_PROD > 0  AND 
			EST_PROD_CPL.TP_PROD = 0  AND 
			EST_PROD_REQ_TRANSF_SLD.CD_FILIAL IN (SELECT ID FROM UFD_PRM_IN_STRING(@CD_FILIAL_SELE)) AND 
			EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA IN(SELECT ID FROM UFD_PRM_IN_STRING(@CD_LIN)) 
		GROUP BY 
			EST_PROD_REQ_TRANSF_SLD.CD_PROD,  
			EST_PROD.DS_PROD, 
			EST_PROD_CPL.STS_PROD,
			EST_PROD_UN_MED.DS_UN, 
			EST_PROD.VLR_CUSTO_GRP,  
			EST_PROD.APRES_QT_CP, 
			EST_PROD.APRES_EMB_CP,  
			EST_PROD.VLR_COMPRA_GRP, 
			EST_PROD_EST_ARV_MERCADOLOGICA.CD_ARV_MERC_LINHA,
			EST_PROD.CD_FABRIC,
			EST_PROD.COMPRA_POR_SUPRIMENTO,
			EST_PROD_CPL.VLR_CUSTO_MD
---------------- Buscando Curva Matriz -------------------
INSERT INTO @RS_MTZ
	SELECT 
		EST_PROD_CPL.CD_PROD,
		DS_SIGLA AS CURVA_MTZ,
		ISNULL(QT_EST,0)
	FROM 
		EST_PROD_CPL INNER JOIN EST_PROD_CURVA_SIGLA ON 
		EST_PROD_CPL.CD_EMP = EST_PROD_CURVA_SIGLA.CD_EMP AND 
		EST_PROD_CPL.CD_SIGLA = EST_PROD_CURVA_SIGLA.CD_SIGLA 
	WHERE
		EST_PROD_CPL.CD_EMP = @CD_EMP 
		AND EST_PROD_CPL.CD_FILIAL = (SELECT top 1 CD_FILIAL FROM PRC_FILIAL WHERE FILIAL_MTZ = 1)


-------------- Atualizando Tabela com a Curva Mtz ----------------------

UPDATE @RS_DADOS SET
		CURVA_MTZ = MTZ.CURVA_MTZ,
		QT_EST_MTZ = MTZ.QT_EST_MTZ  
FROM @RS_DADOS DADOS INNER JOIN @RS_MTZ MTZ ON 
	MTZ.CD_PROD = DADOS.CD_PROD
RETURN
END
